/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.data;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataValueFactory;
import icyllis.flexmark.util.data.MutableDataValueSetter;

public abstract class DataKeyBase<T>
implements MutableDataValueSetter<T> {
    @NotNull
    private final String name;
    @NotNull
    private final DataValueFactory<T> factory;
    private final T defaultValue;

    public DataKeyBase(@NotNull String name, T defaultValue, @NotNull DataValueFactory<T> factory) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.factory = factory;
    }

    public DataKeyBase(@NotNull String name, @NotNull DataKeyBase<T> defaultKey) {
        this(name, defaultKey.defaultValue, defaultKey::get);
    }

    public DataKeyBase(@NotNull String name, T defaultValue) {
        this(name, defaultValue, options -> defaultValue);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public DataValueFactory<T> getFactory() {
        return this.factory;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getDefaultValue(@NotNull DataHolder holder) {
        return this.factory.apply(holder);
    }

    public T get(@Nullable DataHolder holder) {
        return (T)(holder == null ? this.defaultValue : holder.getOrCompute(this, this::getDefaultValue));
    }

    @Deprecated
    public final T getFrom(@Nullable DataHolder holder) {
        return this.get(holder);
    }

    public String toString() {
        if (this.defaultValue != null) {
            return "NullableDataKey<" + this.defaultValue.getClass().getSimpleName() + "> " + this.name;
        }
        return "NullableDataKey<unknown> " + this.name;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

